#include <iostream>
#include <cstdio>
#include <iomanip>
#include <string>
#include "piece.h"
#include "squares.h"


using namespace std;

const string piecechars = ".PpNnBbRrQqKk";
const string colourchars = "wb";

uint ismajor[numpieces];
uint isminor[numpieces];
uint isbigpiece[numpieces]; //N or above
uint iswhite[numpieces];
uint isblack[numpieces];
uint isslide[numpieces];
uint iscolour[numpieces];


const uint sliders[numcolours][3] =
{
     {pwB,pwR,pwQ},
     {pbB,pbR,pbQ}
};


const uint nonsliders[numcolours][2] =
{
     {pwK,pwN},
     {pbK,pbN}
};

const uint pawns[numcolours] =
{
      pwP, pbP
};


const uint kings[numcolours] =
{
      pwK, pbK
};

const uint startrank[numcolours] =
{
      RANK2, RANK7
};

int	const dirN[] = { NNW, NNE, NWW, NEE, SSW, SSE, SEE, SWW, 0 };
int	const dirB[] = { NW, NE, SW, SE, 0 };
int	const dirR[] = { W, E, N, S, 0 };
int	const dirQ[] = { W, E, N, S, NW, NE, SW, SE, 0 };

int const *dirPieces[] = {
	0,
	0,
	0,
	dirN,dirN,
	dirB,dirB,
	dirR,dirR,
    dirQ,dirQ,
    dirQ,dirQ
};

int	const dirwP[] = { NW, NE, N, 0};
int	const dirbP[] = { SW, SE, S, 0};

int const *dirPawn[] = {
    0,
	dirwP,
	dirbP,
};

uint const epdelta[2] = {
    S,N
};

char piecechar(const uint p)
{
    ASS(piecegood(p));
   return piecechars[p];
}


char colourchar(const uint c)
{
    ASS(colourgood(c));
   return colourchars[c];
}

void init_piece_matrices()
{
    uint index;
    for(index = pE; index <= pbK; ++index)
    {
        ASS(piecegood(index));
        ismajor[index] = 0;
        isminor[index] = 0;
        isbigpiece[index] = 0;
        iswhite[index] = 0;
        isblack[index] = 0;
        isslide[index] = 0;
        iscolour[index] = cN;
    }

    for(index = pE; index <= pbK; ++index)
    {
        ASS(piecegood(index));
        if(index > pbB && index < pwK)
        {
            ismajor[index] = 1;
            isbigpiece[index] = 1;
        }
        else if(index > pbP && index < pwR)
        {
            isminor[index] = 1;
            isbigpiece[index] = 1;
        }

        if(index > pbN && index < pwK)
        {
            isslide[index] = 1;
        }
        if(index != pE)
        {
           if(index & 1)
           {
               iswhite[index] = 1;
               iscolour[index] = cW;
           }
           else
           {
               isblack[index] = 1;
               iscolour[index] = cB;
           }
        }
    }
/*
#ifdef DEBUG
    cout<<"\n uint matrix indentifiers: ";
    cout<<endl;
	string mat[7] = { "W","B","big","maj","min","sli","col" };
    cout<<setw(5)<<" ";

    for(index = 0; index < 7; ++index)
    cout<<setw(3)<<mat[index];

    cout<<endl;

    for(index = pE; index <= pbK; ++index)
    {
        cout<<setw(5)<<piecechar(index);
        cout<<setw(4)<<iswhite[index];
        cout<<setw(4)<<isblack[index];
        cout<<setw(4)<<isbigpiece[index];
        cout<<setw(4)<<ismajor[index];
        cout<<setw(4)<<isminor[index];
        cout<<setw(4)<<isslide[index];
        cout<<setw(4)<<iscolour[index];
        cout<<endl;
    }

    cout<<endl;
#endif
*/
}

